package main

import(
	"fmt"
	"time"
	"encoding/xml"
	"encoding/json"
)

const (
 timeout = 10 * time.Second 
)

type Device interface{
	GetStatus() (string,error)
	GetVersion()(int,error)
	GetOut(nr int) (int, error)
	SetOut(nr int , val int)  (error)
	GetAddress() (string,error)
	SetReset(nr int, time int , force bool ) (bool,error)
	Init() (error)
	Toggle(nr int) (error)
}

type DeviceState struct{
	Version int
	Address string
	UpdateTime time.Time
}

type Out_desc struct {
	Id	int	`json:"id"`
	Name      string `json:"name"`
	State     int    `json:"state"`
	ResetTime int    `json:"reset_time"`
}

func (d *DeviceState) GetAddress() string {
	return d.Address
}
type st2_ver struct{
//	XMLName xml.Name `xml:"response"`
	Ver string `xml:"ver"`
}

func validateXML(data []byte) error {
	var v st2_ver
	err := xml.Unmarshal(data, &v)
	return err
}

func check_for_2(ip string) bool{

	Body,_,err := Http_get(ip,"/st2.xml")
	if err != nil {
		return false
	}

	err = validateXML(Body)
	if err != nil {
		return false
	}
	return true;

}

type status_json_ver struct{
	Ver string `json:"hw"`
}

func validateJSON(data []byte) error {
	var v status_json_ver
	err := json.Unmarshal(data, &v)
	return err
}

func check_for_3(ip string) bool{

	Body,_,err := Http_get(ip,"/json/status.json")
	if err != nil {
		return false
	}
	err = validateJSON(Body)
	if err != nil {
		return false
	}
	return true;

}

func getVersion(ip string ) int{
	if check_for_2(ip){
		return 2
	}
	
	if check_for_3(ip) {
		return 3
	}

	return 0

}


func CreateDevice(address string) Device{
	fmt.Printf("CREATING %s\n",address);
	ver := getVersion(address)
	time := time.Time{}
	var device Device
	switch ver{
	case 2:
		device = &Lan20{DeviceState: DeviceState{Version: ver, Address: address, UpdateTime: time}}
	case 3:
		device = &Lan30{DeviceState: DeviceState{Version: ver, Address: address, UpdateTime: time}}
	default:
//		device = &Mock{DeviceState: DeviceState{Version: ver, Address: address, UpdateTime: time}}
		return nil
	}
	device.Init()
	return device
}


