package main

import (
	"fmt"
	"encoding/json"
	"time"
	"strconv"
	"errors"
)



type Lan30 struct{
	DeviceState
	Out [5]Out_desc `json:"outs"`
}


func (l *Lan30) SetReset(nr int, time int , force bool ) (bool,error){
	
	if nr > 4 || nr < 0 {
		return false,errors.New("Index outside of range");
	}
	
	if l.Out[nr].ResetTime == 0 && ! force {
		return false, nil
	}

	path:= fmt.Sprintf("/outs.cgi?ortime=%d%d",nr, time);
	_, err := l.download(path)

	if err != nil{
		return false,err
	}

	return true,nil
}


func (l *Lan30) GetStatus()(string,error) {
        _,err := l.request_status()
        if err != nil {
                return "",err
        }
        jsonData, err := json.MarshalIndent(l,""," ")
        if err != nil {
                return "",err
        }
        return  string(jsonData),nil
} 


func (l *Lan30) GetAddress() (string,error) {
	if l.Address == "" {
		return "", errors.New("Lan 3.0 NO ADDRESS");
	}
	return l.Address,nil
}

func (l *Lan30) Init()(error)  {
	for i := 0 ; i < len(l.Out); i++ {
	l.Out[i].Id = i
	}
	return nil
}

func (l *Lan30) GetVersion()(int,error) {
 fmt.Printf ("I'm lan controler in version 3\n")
 return 3,nil
}

func (l *Lan30) SetOut(nr int, val int) error{
	if nr > 4 || nr < 0 {
		return errors.New("Index outside of range");
	}
	
	path:= fmt.Sprintf("/outs.cgi?out%d=%d",nr,val);
	_, err := l.download(path)

	if err != nil{
		return err
	}

	l.UpdateTime = time.Time{}

	return nil;
}


func (l *Lan30) Toggle(nr int)error{
	if nr > 4 || nr < 0 {
		return errors.New("Index outside of range")
	}

	path:= fmt.Sprintf("/outs.cgi?out=out%d",nr);
	_, err := l.download(path)

	if err != nil{
		return err
	}

	l.UpdateTime = time.Time{}

	return nil
}

func (l *Lan30) GetOut(nr int) (int,error) {
	l.request_status();
	if nr < 0 || nr > 4 {
		return 0, errors.New("out of bouds");
	}
	
	return l.Out[nr].State, nil;

}

type status_per_json struct{
	Out0 string `json:"out0"`
	Out1 string `json:"out1"`
	Out2 string `json:"out2"`
	Out3 string `json:"out3"`
	Out4 string `json:"out4"`
}

type outputs_json struct{

	Reset_time0 string `json:"ortime0"`
	Reset_time1 string `json:"ortime1"`
	Reset_time2 string `json:"ortime2"`
	Reset_time3 string `json:"ortime3"`
	Reset_time4 string `json:"ortime4"`

	Name0 string `json:"oname0"`
	Name1 string `json:"oname1"`
	Name2 string `json:"oname2"`
	Name3 string `json:"oname3"`
	Name4 string `json:"oname4"`
}


func (l *Lan30) get_status_per(data []byte) error {
	var v status_per_json
	err := json.Unmarshal(data, &v)
	if err != nil {
		fmt.Printf("nie udało sie odczytać LAN3.0\n");
		return err
	}
	l.Out[0].State, err = strconv.Atoi(v.Out0)
	l.Out[1].State, err = strconv.Atoi(v.Out1)
	l.Out[2].State, err = strconv.Atoi(v.Out2)
	l.Out[3].State, err = strconv.Atoi(v.Out3)
	l.Out[4].State, err = strconv.Atoi(v.Out4)
	return err
}

func (l *Lan30) get_outputs_data(data []byte) error {
	var v outputs_json
	err := json.Unmarshal(data, &v)
	if err != nil {
		fmt.Printf("nie udało sie odczytać LAN3.0\n");
		return err
	}
	l.Out[0].ResetTime, err = strconv.Atoi(v.Reset_time0)
	l.Out[1].ResetTime, err = strconv.Atoi(v.Reset_time1)
	l.Out[2].ResetTime, err = strconv.Atoi(v.Reset_time2)
	l.Out[3].ResetTime, err = strconv.Atoi(v.Reset_time3)
	l.Out[4].ResetTime, err = strconv.Atoi(v.Reset_time4)

	l.Out[0].Name = v.Name0
	l.Out[1].Name = v.Name1
	l.Out[2].Name = v.Name2
	l.Out[3].Name = v.Name3
	l.Out[4].Name = v.Name4

	return err
}

func (l *Lan30) download(path string) ([]byte,error) {
	Body, _,err := Http_get(l.Address,path)
	return Body,err
}

func (l *Lan30) request_status()(bool,error){
	
	if(time.Since(l.UpdateTime) <= 10 * time.Second){
		return true,nil;
	}

	Body, err := l.download("/json/status_per.json")
	if err != nil {
		return false,err
	}

	err = l.get_status_per(Body)
	if err != nil {
		return false,err
	}
	
	Body, err = l.download("/json/outputs.json")
	if err != nil {
		return false,err
	}

	err = l.get_outputs_data(Body)
	if err != nil {
		return false,err
	}

	l.UpdateTime=time.Now()

	return true,nil;

}

