package main

import (
	"fmt"
	"net/http"
	"strings"
	"regexp"
	"strconv"
	"errors"
)

var pm *ProcessManager


func get_device(address string) Device {
	controler , found := ControlerList.Get(address);
	if ( !found ) {
		fmt.Printf("ADDIGN %s \n",address);
		controler = pm.Process(address)
		if controler != nil {
			ControlerList.Add(controler)
		}
	}
	return controler
}


// get_output is a placeholder for your function that takes a device name as input
func get_output(path string) string {
	fmt.Printf("GET for %s\n",path)
	// Replace this with your actual implementation
	// Define the regular expression pattern
	re := regexp.MustCompile(`^(.+?)/out(\d+)$`)
	// Find the matches
	matches := re.FindStringSubmatch(path)
	if matches == nil {
		fmt.Println("No matches found")
		return "NONE"
	}

	// Extract the address and the number
	address := matches[1]
	number,_ :=  strconv.Atoi(matches[2])

	controler := get_device(address);
	
	if (controler != nil){
		val, err := controler.GetOut(number);
		if err != nil {
		return fmt.Sprintf("%d",val);
		}else{
		return ""
		}
	}else{
		return ""
	}
}

func set_value(path string) {
	// Replace this with your actual implementation
	// Define the regular expression pattern
	re := regexp.MustCompile(`^(.+?)/out(\d+)\?v=(\d)$`)
	fmt.Printf("SET for %s\n",path)
	// Find the matches
	matches := re.FindStringSubmatch(path)
	if matches == nil {
		fmt.Println("No matches found")
		return
	}

	// Extract the address and the number
	address := matches[1]
	number,_ :=  strconv.Atoi(matches[2])
	value,_ :=  strconv.Atoi(matches[3])
	
	controler := get_device(address);

	if (controler != nil){
		err := controler.SetOut(number,value)
		fmt.Printf("device: %s set happen: %s\n", path,err)
		return
	}else{
		fmt.Printf("device: %s seems to not be device at all\n", path)
		return 
	}
}

func reset(path string) {
	// Replace this with your actual implementation
	// Define the regular expression pattern
	re := regexp.MustCompile(`^(.+?)/out(\d+)\?v=(\d)$`)
	fmt.Printf("SET for %s\n",path)
	// Find the matches
	matches := re.FindStringSubmatch(path)
	if matches == nil {
		fmt.Println("No matches found")
		return
	}

	// Extract the address and the number
	address := matches[1]
	number,_ :=  strconv.Atoi(matches[2])
	value,_ :=  strconv.Atoi(matches[3])

	controler := get_device(address);

	if (controler != nil){
		controler.SetOut(number,value)
		return
	}else{
		fmt.Printf("device: %s seems to not be device at all\n", path)
		return 
	}
}

func get_all(path string) (string,error) {

	controler := get_device(path);

	if (controler != nil){
		body,err := controler.GetStatus()
		if err == nil {
			return body,nil
		}else{
			fmt.Printf("device: %s get_all happen: %s\n", path,err)
			return "",err
		}
	}
	return "",errors.New("There is no such device ")
}


func toggle_output(path string) string {
	fmt.Printf("GET for %s\n",path)
	// Replace this with your actual implementation
	// Define the regular expression pattern
	re := regexp.MustCompile(`^(.+?)/out(\d+)$`)
	// Find the matches
	matches := re.FindStringSubmatch(path)
	if matches == nil {
		fmt.Println("No matches found")
		return "NONE"
	}

	// Extract the address and the number
	address := matches[1]
	number,_ :=  strconv.Atoi(matches[2])

	 controler := get_device(address);
	
	if (controler != nil){
		controler.Toggle(number);
		return "DONE" 
	}else{
		return "NONE"
	}
}


func set_reset (path string, time int, force bool) string{
	// Replace this with your actual implementation
	// Define the regular expression pattern
	re := regexp.MustCompile(`^(.+?)/out(\d+)$`)
	// Find the matches
	matches := re.FindStringSubmatch(path)
	if matches == nil {
		fmt.Println("No matches found")
		return "NONE"
	}

	// Extract the address and the number
	address := matches[1]
	number,_ :=  strconv.Atoi(matches[2])

	controler := get_device(address);
	
	controler.SetReset(number,time,force);
	if (controler != nil){
		return fmt.Sprintf("asd");
	}else{
		return "NONE"
	}
}

// setupRouter initializes the HTTP routes
func setupRouter() *http.ServeMux {
	mux := http.NewServeMux()
	pm = NewProcessManager()
	// Get the current working directory
	dir := "/var/www/"
	fmt.Printf("dir is %s\n",dir);
	// Serve files from the current directory
	fs := http.FileServer(http.Dir(dir))

	// Handle the root URL by serving the index.html file
	mux.Handle("/", fs)

	mux.HandleFunc("/list/", func(w http.ResponseWriter, r *http.Request) {
		path := strings.TrimPrefix(r.URL.Path, "/list/")
		if path != "" {
			http.Error(w, "Device specified!", http.StatusBadRequest)
			return
		} 
		fmt.Printf("LIST\n");
		str,_ := ControlerList.GetAllAddresses()
		fmt.Fprintf(w, "%s",str)
	})

	// Handle /get/<device> paths
	mux.HandleFunc("/get/", func(w http.ResponseWriter, r *http.Request) {
		path := strings.TrimPrefix(r.URL.Path, "/get/")
		if path == "" {
			http.Error(w, "Device not specified", http.StatusBadRequest)
			return
		} 
		fmt.Printf("path:%s\n",path);
		str:=get_output(path)
		fmt.Fprintf(w, "%s",str)
	})

	mux.HandleFunc("/get-all/", func(w http.ResponseWriter, r *http.Request) {
		path := strings.TrimPrefix(r.URL.Path, "/get-all/")
		if path == "" {
			http.Error(w, "Device not specified", http.StatusBadRequest)
			return
		} 
		str,err := get_all(path)
		if err != nil  {
			http.Error(w, "Erorr during device processing", http.StatusInternalServerError)
			return
		}
		fmt.Fprintf(w, "%s",str)
	})
	
	mux.HandleFunc("/set-reset/", func(w http.ResponseWriter, r *http.Request) {
		path := strings.TrimPrefix(r.URL.Path, "/set-reset/")
		
		var force bool

		if path == "" {
			http.Error(w, "Device not specified", http.StatusBadRequest)
			return
		} 

		t := r.URL.Query().Get("t")
		if t == "" {
			http.Error(w, "Time not specifed", http.StatusBadRequest)
			return
		}
		time , err := strconv.Atoi(t);
		if err != nil{
			http.Error(w, "Time is not correct", http.StatusBadRequest)
			return
		}
		
		f := r.URL.Query().Get("f")
		if f == "" || f == "0"  {
			force = false;
		}else{
			force = true;
		}
		str:=set_reset(path, time, force)
		fmt.Fprintf(w, "%s",str)
	})

	mux.HandleFunc("/reset/", func(w http.ResponseWriter, r *http.Request) {
		path := strings.TrimPrefix(r.URL.Path, "/reset/")
		if path == "" {
			http.Error(w, "Device not specified", http.StatusBadRequest)
			return
		} 
		reset(path)
		str:= "asda"
		fmt.Fprintf(w, "%s",str)
	})

	mux.HandleFunc("/toggle/", func(w http.ResponseWriter, r *http.Request) {
		path := strings.TrimPrefix(r.URL.Path, "/toggle/")
		if path == "" {
			http.Error(w, "Device not specified", http.StatusBadRequest)
			return
		} 
		fmt.Printf("path:%s\n",path);
		toggle_output(path)

		something := get_output(path)
		fmt.Fprintf(w, "%s",something)
	})


	mux.HandleFunc("/set/", func(w http.ResponseWriter, r *http.Request) {
		path := strings.TrimPrefix(r.URL.Path, "/set/")
		if path == "" {
			http.Error(w, "Device not specified", http.StatusBadRequest)
			return
		}
		get_path := path
		path = fmt.Sprintf("%s?v=%s",path, r.URL.Query().Get("v"))

		set_value(path)
		something := get_output(get_path)
		fmt.Fprintf(w,something)
	})

	return mux
}
