package main

import (
    "sync"
)

type ProcessManager struct {
    mu        sync.Mutex
    inProcess map[string]chan Device
}

func NewProcessManager() *ProcessManager {
    return &ProcessManager{
        inProcess: make(map[string]chan Device),
    }
}


func (pm *ProcessManager) Process(address string) Device {
    pm.mu.Lock()

    if ch, exists := pm.inProcess[address]; exists {
        // If the input is already being processed, wait for the result
        pm.mu.Unlock()
        return <-ch
    }

    // Mark the input as being processed
    ch := make(chan Device)
    pm.inProcess[address] = ch
    pm.mu.Unlock()

    // Perform the actual processing
    result := CreateDevice(address)

    // Store the result and notify all waiting goroutines
    pm.mu.Lock()
    delete(pm.inProcess, address)
    close(ch)
    for len(ch) > 0 {
        <-ch // Drain the channel to unblock all waiting goroutines
    }
    pm.mu.Unlock()

    return result
}

